<?php

namespace App\Moron\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Dependencia extends Model 
{

    protected $table = 'dependencia';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function tramites()
    {
        return $this->hasMany('Tramite', 'dependencia_id');
    }

    public function usuarios()
    {
        return $this->hasMany('DependenciaUsuario', 'dependencia_id');
    }

}